/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize;

import io.gitlab.jfronny.commons.SamWithReceiver;
import io.gitlab.jfronny.commons.serialize.RToken;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.emulated.ReaderItemView;
import io.gitlab.jfronny.commons.throwable.Unchecked;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public abstract class SerializeReader<TEx extends Exception, T extends SerializeReader<TEx, T>>
implements AutoCloseable,
Iterable<RToken> {
    protected boolean lenient = false;
    protected boolean serializeSpecialFloatingPointValues = false;
    protected int nestingLimit = 255;

    public boolean isLenient() {
        return this.lenient;
    }

    public T setLenient(boolean lenient) {
        this.lenient = lenient;
        if (lenient) {
            return this.setSerializeSpecialFloatingPointValues(true);
        }
        return (T)this;
    }

    public boolean isSerializeSpecialFloatingPointValues() {
        return this.serializeSpecialFloatingPointValues;
    }

    public T setSerializeSpecialFloatingPointValues(boolean serializeSpecialFloatingPointValues) {
        this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
        return (T)this;
    }

    public boolean isStandaloneNames() {
        return false;
    }

    public int getNestingLimit() {
        return this.nestingLimit;
    }

    public T setNestingLimit(int nestingLimit) {
        if (nestingLimit < 0) {
            throw new IllegalArgumentException("Invalid nesting limit: " + nestingLimit);
        }
        this.nestingLimit = nestingLimit;
        return (T)this;
    }

    public abstract T beginArray() throws TEx;

    public abstract T endArray() throws TEx;

    public <R> R array(SerializeReaderFunction<TEx, T, R> consumer) throws TEx {
        this.beginArray();
        R result = consumer.accept(this);
        this.endArray();
        return result;
    }

    public <R> List<R> arrayByElements(SerializeReaderFunction<TEx, T, R> consumer) throws TEx {
        ArrayList<R> result = new ArrayList<R>();
        this.beginArray();
        while (this.hasNext()) {
            result.add(consumer.accept(this));
        }
        this.endArray();
        return result;
    }

    public abstract T beginObject() throws TEx;

    public abstract T endObject() throws TEx;

    public <R> R object(SerializeReaderFunction<TEx, T, R> consumer) throws TEx {
        this.beginObject();
        R result = consumer.accept(this);
        this.endObject();
        return result;
    }

    public abstract boolean hasNext() throws TEx;

    public abstract Token peek() throws TEx;

    public abstract String nextName() throws TEx;

    public abstract String nextString() throws TEx;

    public abstract boolean nextBoolean() throws TEx;

    public abstract void nextNull() throws TEx;

    public double nextDouble() throws TEx {
        return this.nextNumber().doubleValue();
    }

    public long nextLong() throws TEx {
        return this.nextNumber().longValue();
    }

    public int nextInt() throws TEx {
        return this.nextNumber().intValue();
    }

    public abstract Number nextNumber() throws TEx;

    public abstract void skipValue() throws TEx;

    public abstract String getPath();

    public abstract String getPreviousPath();

    @Override
    public abstract void close() throws TEx;

    public SerializeReader<TEx, ?> createView() {
        return new ReaderItemView(this);
    }

    public RToken next() throws TEx {
        return switch (this.peek()) {
            default -> throw new MatchException(null, null);
            case Token.BEGIN_ARRAY -> {
                this.beginArray();
                yield RToken.Simple.BEGIN_ARRAY;
            }
            case Token.END_ARRAY -> {
                this.endArray();
                yield RToken.Simple.END_ARRAY;
            }
            case Token.BEGIN_OBJECT -> {
                this.beginObject();
                yield RToken.Simple.BEGIN_OBJECT;
            }
            case Token.END_OBJECT -> {
                this.endObject();
                yield RToken.Simple.END_OBJECT;
            }
            case Token.NAME -> new RToken.Name(this.nextName());
            case Token.STRING -> new RToken.String(this.nextString());
            case Token.NUMBER -> new RToken.Number(this.nextNumber());
            case Token.BOOLEAN -> new RToken.Boolean(this.nextBoolean());
            case Token.NULL -> {
                this.nextNull();
                yield RToken.Simple.NULL;
            }
            case Token.END_DOCUMENT -> RToken.Simple.END_DOCUMENT;
        };
    }

    @NotNull
    public Stream<RToken> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 272), false);
    }

    @NotNull
    public TokenIterator iterator() {
        return new TokenIterator();
    }

    public <TEx2 extends Exception> void copyTo(SerializeWriter<TEx2, ?> writer) throws TEx, TEx2 {
        switch (this.peek()) {
            case BEGIN_ARRAY: {
                this.beginArray();
                writer.beginArray();
                while (this.hasNext()) {
                    this.copyTo(writer);
                }
                this.endArray();
                writer.endArray();
                break;
            }
            case END_ARRAY: {
                throw new IllegalStateException("Cannot copy standalone END_ARRAY");
            }
            case BEGIN_OBJECT: {
                this.beginObject();
                writer.beginObject();
                while (this.hasNext()) {
                    writer.name(this.nextName());
                    this.copyTo(writer);
                }
                this.endObject();
                writer.endObject();
                break;
            }
            case END_OBJECT: {
                throw new IllegalStateException("Cannot copy standalone END_OBJECT");
            }
            case NAME: {
                if (this.isStandaloneNames() && writer.isStandaloneNames()) {
                    writer.name(this.nextName());
                    break;
                }
                throw new IllegalStateException("Cannot copy standalone NAME");
            }
            case STRING: {
                writer.value(this.nextString());
                break;
            }
            case NUMBER: {
                writer.value(this.nextNumber());
                break;
            }
            case BOOLEAN: {
                writer.value(this.nextBoolean());
                break;
            }
            case NULL: {
                this.nextNull();
                writer.nullValue();
                break;
            }
            case END_DOCUMENT: {
                throw new IllegalStateException("Cannot copy END_DOCUMENT");
            }
        }
    }

    protected abstract TEx createException(String var1);

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    protected String locationString() {
        return " at path " + this.getPath();
    }

    @SamWithReceiver
    public static interface SerializeReaderFunction<TEx extends Exception, T extends SerializeReader<TEx, T>, R> {
        public R accept(T var1) throws TEx;
    }

    public class TokenIterator
    implements Iterator<RToken> {
        int depth = 0;

        @Override
        public boolean hasNext() {
            try {
                return this.depth > 0 || SerializeReader.this.hasNext();
            }
            catch (Exception e) {
                return (Boolean)Unchecked.sneakyThrow(e);
            }
        }

        @Override
        public RToken next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more tokens");
            }
            Unchecked.reintroduce();
            try {
                RToken token = SerializeReader.this.next();
                if (token == RToken.Simple.BEGIN_ARRAY || token == RToken.Simple.BEGIN_OBJECT) {
                    ++this.depth;
                } else if (token == RToken.Simple.END_ARRAY || token == RToken.Simple.END_OBJECT) {
                    --this.depth;
                }
                return token;
            }
            catch (Exception e) {
                return (RToken)Unchecked.sneakyThrow(e);
            }
        }
    }

    public static abstract class Delegating<TEx extends Exception, Reader extends Delegating<TEx, Reader>>
    extends SerializeReader<TEx, Reader> {
        protected final SerializeReader<TEx, ?> delegate;

        public Delegating(SerializeReader<TEx, ?> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public boolean isLenient() {
            this.lenient = this.delegate.isLenient();
            return this.lenient;
        }

        @Override
        public Reader setLenient(boolean lenient) {
            this.delegate.setLenient(lenient);
            this.lenient = lenient;
            return (Reader)this;
        }

        @Override
        public boolean isSerializeSpecialFloatingPointValues() {
            this.serializeSpecialFloatingPointValues = this.delegate.isSerializeSpecialFloatingPointValues();
            return this.serializeSpecialFloatingPointValues;
        }

        @Override
        public Reader setSerializeSpecialFloatingPointValues(boolean serializeSpecialFloatingPointValues) {
            this.delegate.setSerializeSpecialFloatingPointValues(serializeSpecialFloatingPointValues);
            this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
            return (Reader)this;
        }

        @Override
        public boolean isStandaloneNames() {
            return this.delegate.isStandaloneNames();
        }

        @Override
        public int getNestingLimit() {
            this.nestingLimit = this.delegate.getNestingLimit();
            return this.nestingLimit;
        }

        @Override
        public Reader setNestingLimit(int nestingLimit) {
            this.delegate.setNestingLimit(nestingLimit);
            this.nestingLimit = nestingLimit;
            return (Reader)this;
        }

        @Override
        public String getPath() {
            return this.delegate.getPath();
        }

        @Override
        public String getPreviousPath() {
            return this.delegate.getPreviousPath();
        }

        @Override
        protected String locationString() {
            return this.delegate.locationString();
        }

        @Override
        protected TEx createException(String message) {
            return this.delegate.createException(message);
        }

        @Override
        public abstract double nextDouble() throws TEx;

        @Override
        public abstract long nextLong() throws TEx;

        @Override
        public abstract int nextInt() throws TEx;
    }
}

